/*-----------------------------------------------------------------------------
	[Cartridge.c]
		J[gbW̓ǂݍݓsȂ܂D

	Copyright (C) 2004 Ki

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
**---------------------------------------------------------------------------*/
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "Cartridge.h"


static
BOOL
read_384k(
	FILE*		p,
	Uint8*		pRom)
{
	/* mask  0xfffff ɂȂ̂ŁA$000000 - $100000 ؂Ė߂ */
	if (fread(pRom, sizeof(Uint8), 262144, p) != 262144)
		return FALSE;

	fseek(p, 0, SEEK_SET);

	if (fread(pRom + 262144, sizeof(Uint8), 393216, p) != 393216)
		return FALSE;

	memcpy(pRom+262144+393216, pRom, 0x100000-(262144+393216));

	return TRUE;
}


/*-----------------------------------------------------------------------------
** [LoadCartridge]
**	 J[gbWt@Cǂݍ݂܂D
** J[gbWɕKvȗ̈̊mۂsȂ܂D
** ǂݍ񂾃J[gbW̃}XNlԂ܂D([Ȃ玸s)
**---------------------------------------------------------------------------*/
Uint32
LoadCartridge(
	const char*		pGameName,
	Uint8**			ppRom)
{
	FILE*	pFile;
	Sint32	fileSize;
	Uint32	mask;

	pFile = fopen(pGameName, "rb");
	
	if (pFile == NULL)
	{
		return 0;
	}

	fseek(pFile, 0, SEEK_END);
	fileSize = ftell(pFile);
	fseek(pFile, 0, SEEK_SET);

	// ROM MASK ̒l肷B 
	// ROM ̃TCY $6000 Ȃǂ̏ꍇ
	// (Qׂ̂łȂꍇ)lB 
	mask = 0x2000;
	while (mask < fileSize)
	{
		mask <<= 1;
	}

	if (fileSize == 393216)
	{
		mask = 1 << 20;
	}

	// ۂɂ͂Qׂ̂Ŋmۂ ($6000 ̏ꍇ $8000)
	*ppRom = malloc(mask);
	if (*ppRom == NULL)
	{
		fclose(pFile);
		return 0;
	}
	memset(*ppRom, 0xff, mask);
	--mask;	

	if (fileSize == 393216)
	{
		if (!read_384k(pFile, *ppRom))
		{
			fclose(pFile);
			free(*ppRom);
			return 0;
		}
	}
	else if (fread(*ppRom, sizeof(Uint8), fileSize, pFile) != fileSize)
	{
		fclose(pFile);
		free(*ppRom);
		return 0;
	}

	fclose(pFile);
	return mask;
}


/*-----------------------------------------------------------------------------
** [FreeCartridge]
**	 J[gbWj܂D
** J[gbWpɊmۂ̈܂D
**---------------------------------------------------------------------------*/
void
FreeCartridge(
	Uint8*		pRom)
{
	free(pRom);
}


